/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.Expression;
import com.mckoi.database.ExpressionPreparer;
import com.mckoi.database.StatementException;
import com.mckoi.database.StatementTree;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.TransactionException;
import com.mckoi.database.User;
import com.mckoi.database.Variable;
import com.mckoi.database.interpret.FromTableInterface;
import com.mckoi.database.interpret.Select;
import com.mckoi.database.jdbc.SQLQuery;
import com.mckoi.debug.DebugLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class Statement {
    protected DatabaseConnection database;
    protected User user;
    protected StatementTree cmd;
    protected SQLQuery query;
    protected Vector table_list = new Vector();

    public final DebugLogger Debug() {
        return this.database.Debug();
    }

    void reset() {
        this.database = null;
        this.user = null;
        this.table_list = new Vector();
    }

    public final void resolveTree() throws DatabaseException {
        ExpressionPreparer preparer = new ExpressionPreparer(){

            public boolean canPrepare(Object element) {
                return element instanceof StatementTree;
            }

            public Object prepare(Object element) throws DatabaseException {
                StatementTree stmt_tree = (StatementTree)element;
                Select stmt = new Select();
                stmt.init(Statement.this.database, stmt_tree, null);
                stmt.resolveTree();
                stmt.prepare();
                return stmt;
            }
        };
        this.cmd.prepareAllExpressions(preparer);
    }

    FromTableInterface findTableWithColumn(Variable column_name) {
        for (int i = 0; i < this.table_list.size(); ++i) {
            int rcc;
            FromTableInterface table = (FromTableInterface)this.table_list.elementAt(i);
            TableName tname = column_name.getTableName();
            String sch_name = null;
            String tab_name = null;
            String col_name = column_name.getName();
            if (tname != null) {
                sch_name = tname.getSchema();
                tab_name = tname.getName();
            }
            if ((rcc = table.resolveColumnCount(null, sch_name, tab_name, col_name)) <= 0) continue;
            return table;
        }
        return null;
    }

    boolean existsTableWithColumn(Variable column_name) {
        return this.findTableWithColumn(column_name) != null;
    }

    ArrayList resolveAgainstAliases(Variable alias_name) {
        return new ArrayList(0);
    }

    TableName resolveTableName(String name, DatabaseConnection db) {
        return db.resolveTableName(name);
    }

    FromTableInterface findTableInQuery(String schema, String name) {
        for (int p = 0; p < this.table_list.size(); ++p) {
            FromTableInterface table = (FromTableInterface)this.table_list.get(p);
            if (!table.matchesReference(null, schema, name)) continue;
            return table;
        }
        return null;
    }

    Variable resolveColumn(Variable v) {
        ArrayList<Variable> list = new ArrayList<Variable>();
        list.addAll(this.resolveAgainstAliases(v));
        TableName tname = v.getTableName();
        String sch_name = null;
        String tab_name = null;
        String col_name = v.getName();
        if (tname != null) {
            sch_name = tname.getSchema();
            tab_name = tname.getName();
        }
        boolean matches_found = false;
        for (int i = 0; i < this.table_list.size(); ++i) {
            FromTableInterface table = (FromTableInterface)this.table_list.elementAt(i);
            int rcc = table.resolveColumnCount(null, sch_name, tab_name, col_name);
            if (rcc == 1) {
                Variable matched = table.resolveColumn(null, sch_name, tab_name, col_name);
                list.add(matched);
                continue;
            }
            if (rcc <= 1) continue;
            throw new StatementException("Ambiguous column name (" + v + ")");
        }
        int total_matches = list.size();
        if (total_matches == 0) {
            throw new StatementException("Can't find column: " + v);
        }
        if (total_matches == 1) {
            return (Variable)list.get(0);
        }
        if (total_matches > 1) {
            throw new StatementException("Ambiguous column name (" + v + ")");
        }
        throw new Error("Negative total matches?");
    }

    public Variable resolveVariableName(Variable v) {
        return this.resolveColumn(v);
    }

    void resolveExpression(Expression exp) {
        List vars = exp.allVariables();
        for (int i = 0; i < vars.size(); ++i) {
            Variable v = (Variable)vars.get(i);
            Variable to_set = this.resolveVariableName(v);
            v.set(to_set);
        }
    }

    protected void addTable(FromTableInterface table) {
        this.table_list.addElement(table);
    }

    public final void init(DatabaseConnection db, StatementTree stree, SQLQuery query) {
        this.database = db;
        this.user = db.getUser();
        this.cmd = stree;
        this.query = query;
    }

    public abstract void prepare() throws DatabaseException;

    public abstract Table evaluate() throws DatabaseException, TransactionException;
}

